/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Element;

import woolpack.fn.Fn;

/**
 * DOM エレメントの属性を削除する{@link Fn}です。
 * @author nakamura
 *
 */
public class AttrRemover implements Fn<NodeContext, Void> {
	private String attrName;
	
	public AttrRemover(final String attrName) {
		this.attrName = attrName;
	}

	public Void exec(final NodeContext c) {
		final Element element = (Element) c.getNode();
		element.removeAttribute(attrName);
		return null;
	}

	public String getAttrName() {
		return attrName;
	}
	public void setAttrName(final String attrName) {
		this.attrName = attrName;
	}
}
