/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.web;

import woolpack.container.ContainerContext;
import woolpack.fn.Fn;

/**
 * {@link WebContext#setContainer(Object)}に{@link ContainerContext}を設定する{@link Fn}です。
 * @author nakamura
 *
 */
public class ContainerContextSetter implements Fn<WebContext, Void> {
	private Fn<? super ContainerContext<WebContext>, ?> fn;
	
	public ContainerContextSetter(final Fn<? super ContainerContext<WebContext>, ?> fn) {
		this.fn = fn;
	}

	public Void exec(final WebContext c) {
		final ContainerContext<WebContext> context = new ContainerContext<WebContext>();
		context.setFn(fn);
		context.setSubContext(c);
		c.setContainer(context);
		return null;
	}

	public Fn<? super ContainerContext<WebContext>, ?> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super ContainerContext<WebContext>, ?> fn) {
		this.fn = fn;
	}
}
