/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package woolpack.visitor;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import woolpack.fn.Fn;
import woolpack.xml.XmlUtils;

/**
 * コンテキストに DOM エレメントを追加して子ノードの処理を委譲する{@link Fn}です。
 * @author nakamura
 *
 */
public class ElementAcceptor implements Fn<Visitor<Node>, Void> {
	private final String elementName;
	private final Fn<? super Visitor<Node>, Void> acceptor;
	
	public ElementAcceptor(
			final String elementName,
			final Fn<? super Visitor<Node>, Void> acceptor) {
		this.elementName = elementName;
		this.acceptor = acceptor;
	}
	
	public ElementAcceptor(
			final String elementName) {
		this(elementName, VisitorUtils.ECHO_ACCEPTOR);
	}

	public Void exec(final Visitor<Node> visitor) {
		final Element node = (Element) visitor.getSubContext();
		final Element element = XmlUtils.getDocumentNode(node).createElement(elementName);
		node.appendChild(element);
		VisitorUtils.localContext(element, visitor, acceptor);
		return null;
	}
}
