/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.factory;

import java.io.StringReader;

import woolpack.fn.Fn;

/**
 * {@link StringReader}を返すテスト用の{@link Fn}です。
 * 
 * @author nakamura
 * 
 */
public class StringReaderFactory implements Fn<Object, StringReader> {
	private String content;

	public StringReaderFactory(final String s) {
		this.content = s;
	}

	public StringReader exec(final Object c) {
		return new StringReader(content);
	}

	public String getContent() {
		return content;
	}
	public void setContent(final String content) {
		this.content = content;
	}
}
