/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.ee;

import java.io.InputStream;

import javax.servlet.ServletContext;

import woolpack.fn.Fn;

/**
 * {@link ServletContext#getResourceAsStream(java.lang.String)}
 * を使用して{@link InputStream}を取得するファクトリです。
 * 本クラスは Servlet API のライブラリを使用します。
 * <br/>適用しているデザインパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class ServletInputStreamFactory implements Fn<String, InputStream> {
	private final ServletContext context;

	public ServletInputStreamFactory(final ServletContext context) {
		this.context = context;
	}

	public InputStream exec(final String c) {
		return context.getResourceAsStream(c);
	}
}
