/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

/**
 * 比較する{@link Fn}です。
 * @author nakamura
 *
 * @param <C>
 */
public class CompareFn<C extends Comparable<C>> implements Fn<C, Integer> {
	private C value;
	
	public CompareFn(final C value) {
		this.value = value;
	}

	public Integer exec(final C c) {
		return value.compareTo(c);
	}

	public C getValue() {
		return value;
	}
	public void setValue(final C value) {
		this.value = value;
	}
}
