/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.tx;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import woolpack.sql.adapter.ConnectionAdapter;
import woolpack.sql.adapter.PreparedStatementAdapter;
import woolpack.sql.adapter.ResultSetAdapter;
import woolpack.sql.adapter.StatementAdapter;
import woolpack.sql.tx.TxTemporaryCloser;

class TxContext {
    private Connection connection;
    private List<TxTemporaryCloser> list;
    private boolean commitFlag;
    private boolean rollbackFlag;

    TxContext() {
    }

    void commit() {
        this.commitFlag = true;
    }

    boolean isCommit() {
        return this.commitFlag;
    }

    void rollback() {
        this.rollbackFlag = true;
    }

    boolean isRollback() {
        return this.rollbackFlag;
    }

    Connection getConnection() {
        return this.connection;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
        this.rollbackFlag = false;
        this.commitFlag = false;
        this.list = new ArrayList<TxTemporaryCloser>();
    }

    void closeAll() throws SQLException {
        SQLException exception = null;
        while (!this.list.isEmpty()) {
            try {
                this.list.get(this.list.size() - 1).close();
            }
            catch (SQLException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void remove(Object o) throws SQLException {
        int i = this.list.size() - 1;
        while (i >= 0) {
            TxTemporaryCloser closer = this.list.get(i);
            if (closer.getObject() == o) {
                this.list.remove(i);
                break;
            }
            --i;
        }
    }

    Connection newTmpConnection() {
        return new ConnectionAdapter(this.connection){

            public void commit() throws SQLException {
                TxContext.this.commit();
            }

            public void rollback() throws SQLException {
                TxContext.this.rollback();
            }

            public void close() throws SQLException {
            }

            public Statement createStatement() throws SQLException {
                return TxContext.this.newStatement(super.createStatement());
            }

            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return TxContext.this.newStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                return TxContext.this.newStatement(super.createStatement(resultSetType, resultSetConcurrency));
            }

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return TxContext.this.newPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                return TxContext.this.newPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency));
            }

            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                return TxContext.this.newPreparedStatement(super.prepareStatement(sql, autoGeneratedKeys));
            }

            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                return TxContext.this.newPreparedStatement(super.prepareStatement(sql, columnIndexes));
            }

            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                return TxContext.this.newPreparedStatement(super.prepareStatement(sql, columnNames));
            }

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                return TxContext.this.newPreparedStatement(super.prepareStatement(sql));
            }
        };
    }

    private Statement newStatement(Statement parent) {
        final StatementAdapter s = new StatementAdapter(parent){

            public void close() throws SQLException {
                try {
                    super.close();
                }
                finally {
                    TxContext.this.remove(this);
                }
            }

            public ResultSet executeQuery(String sql) throws SQLException {
                return TxContext.this.newResultSet(super.executeQuery(sql), this);
            }

            public ResultSet getGeneratedKeys() throws SQLException {
                return TxContext.this.newResultSet(super.getGeneratedKeys(), this);
            }

            public ResultSet getResultSet() throws SQLException {
                return TxContext.this.newResultSet(super.getResultSet(), this);
            }
        };
        this.list.add(new TxTemporaryCloser(s){

            void close() throws SQLException {
                s.close();
            }
        });
        return s;
    }

    private PreparedStatement newPreparedStatement(PreparedStatement parent) {
        final PreparedStatementAdapter s = new PreparedStatementAdapter(parent){

            public void close() throws SQLException {
                try {
                    super.close();
                }
                finally {
                    TxContext.this.remove(this);
                }
            }

            public ResultSet executeQuery() throws SQLException {
                return TxContext.this.newResultSet(super.executeQuery(), this);
            }

            public ResultSet executeQuery(String sql) throws SQLException {
                return TxContext.this.newResultSet(super.executeQuery(sql), this);
            }

            public ResultSet getGeneratedKeys() throws SQLException {
                return TxContext.this.newResultSet(super.getGeneratedKeys(), this);
            }

            public ResultSet getResultSet() throws SQLException {
                return TxContext.this.newResultSet(super.getResultSet(), this);
            }
        };
        this.list.add(new TxTemporaryCloser(s){

            void close() throws SQLException {
                s.close();
            }
        });
        return s;
    }

    private ResultSet newResultSet(ResultSet parent, final Statement statement) {
        final ResultSetAdapter s = new ResultSetAdapter(parent){

            public void close() throws SQLException {
                try {
                    super.close();
                }
                finally {
                    TxContext.this.remove(this);
                }
            }

            public Statement getStatement() throws SQLException {
                return statement;
            }
        };
        this.list.add(new TxTemporaryCloser(s){

            void close() throws SQLException {
                s.close();
            }
        });
        return s;
    }
}

