/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneLineResult<R>
implements Fn<Statement, R> {
    private Fn<? super ResultSet, ? extends R> rowFn;
    private Fn<? super Statement, ? extends R> zeroFn;

    public OneLineResult(Fn<? super ResultSet, ? extends R> rowFn, Fn<? super Statement, ? extends R> zeroFn) {
        this.rowFn = rowFn;
        this.zeroFn = zeroFn;
    }

    public OneLineResult(Fn<? super ResultSet, ? extends R> rowFn) {
        this(rowFn, new Fn<Statement, R>(){

            @Override
            public R exec(Statement c) {
                throw new IllegalStateException("empty row.");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R exec(Statement c) {
        try {
            ResultSet resultSet = c.getResultSet();
            try {
                if (resultSet.next()) {
                    R r = this.rowFn.exec(resultSet);
                    return r;
                }
                R r = this.zeroFn.exec(c);
                return r;
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Fn<? super ResultSet, ? extends R> getRowFn() {
        return this.rowFn;
    }

    public void setRowFn(Fn<? super ResultSet, ? extends R> fn) {
        this.rowFn = fn;
    }

    public Fn<? super PreparedStatement, ? extends R> getZeroFn() {
        return this.zeroFn;
    }

    public void setZeroFn(Fn<? super Statement, ? extends R> zeroFn) {
        this.zeroFn = zeroFn;
    }
}

