/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapResult
implements Fn<ResultSet, Map<String, Object>> {
    private static final Fn<? super Integer, ? extends Map<String, Object>> DEFAULT_MAP_FACTORY = new Fn<Integer, Map<String, Object>>(){

        @Override
        public Map<String, Object> exec(Integer c) {
            return new HashMap<String, Object>(c);
        }
    };
    private Fn<? super Integer, ? extends Map<String, Object>> mapFactory;

    public MapResult(Fn<? super Integer, ? extends Map<String, Object>> mapFactory) {
        this.mapFactory = mapFactory;
    }

    public MapResult() {
        this(DEFAULT_MAP_FACTORY);
    }

    @Override
    public Map<String, Object> exec(ResultSet c) {
        try {
            ResultSetMetaData metaData = c.getMetaData();
            int size = metaData.getColumnCount();
            Map<String, Object> map = this.mapFactory.exec((Integer)size);
            int i = 0;
            while (i < size) {
                map.put(metaData.getColumnName(i + 1), c.getObject(i + 1));
                ++i;
            }
            return map;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Fn<? super Integer, ? extends Map<String, Object>> getMapFactory() {
        return this.mapFactory;
    }

    public void setMapFactory(Fn<? super Integer, ? extends Map<String, Object>> mapFactory) {
        this.mapFactory = mapFactory;
    }
}

