/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Element;
import woolpack.ee.EEContext;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.utils.BuildableArrayList;
import woolpack.utils.Utils;
import woolpack.xml.NodeFindable;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionBuilder {
    private static final int TOKEN_LENGTH = 32;
    private static final int DEGIT_COUNT = 10;
    private static final int TOKEN_CHAR_COUNT = 36;
    public static final String KEY = "woolpack.transaction.TRANSACTION_TOKEN";
    private final String key;
    private final Random r;
    private final Collection<String> idCollection;
    private final int size;
    private final NodeFindable xpathForm;
    private final NodeFindable xpathHref;

    public TransactionBuilder(String key, Collection<String> idCollection, int size, Fn<String, NodeFindable> factory) {
        this.key = key;
        this.r = new Random();
        this.idCollection = idCollection;
        this.size = size;
        this.xpathForm = factory.exec("//FORM");
        this.xpathHref = factory.exec("//A[@href]");
    }

    public TransactionBuilder(Collection<String> idCollection, Fn<String, NodeFindable> factory) {
        this(KEY, idCollection, 32, factory);
    }

    String generateToken() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size) {
            int j = this.r.nextInt(36);
            sb.append(j < 10 ? (char)(48 + j) : (char)(65 + j - 10));
            ++i;
        }
        return sb.toString();
    }

    public Fn<EEContext, Void> getCheckExpression(final Fn<? super EEContext, Void> trueExpression, final Fn<? super EEContext, Void> falseExpression) {
        return new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                if (TransactionBuilder.this.idCollection.contains(context.getId())) {
                    Object oldToken = context.getSession().get(TransactionBuilder.this.key);
                    List requestedTokens = Utils.toList(context.getInput().get(TransactionBuilder.this.key));
                    String newToken = TransactionBuilder.this.generateToken();
                    if (oldToken != null && oldToken.equals(requestedTokens.get(0)) && context.getSession().replace(TransactionBuilder.this.key, oldToken, newToken)) {
                        trueExpression.exec(context);
                    } else {
                        falseExpression.exec(context);
                    }
                } else {
                    String newToken;
                    Object oldToken;
                    do {
                        oldToken = context.getSession().get(TransactionBuilder.this.key);
                        newToken = TransactionBuilder.this.generateToken();
                    } while (!(oldToken == null ? context.getSession().putIfAbsent(TransactionBuilder.this.key, newToken) == null : context.getSession().replace(TransactionBuilder.this.key, oldToken, newToken)));
                    trueExpression.exec(context);
                }
                return null;
            }
        };
    }

    public Fn<EEContext, Void> getAppendExpression() {
        return FnUtils.seq((Iterable)new BuildableArrayList<Fn>().list(XmlUtils.findNode(this.xpathForm, new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                String token = (String)context.getSession().get(TransactionBuilder.this.key);
                if (token != null) {
                    Element element = XmlUtils.getDocumentNode(context.getNode()).createElement("INPUT");
                    element.setAttribute("type", "hidden");
                    element.setAttribute("name", TransactionBuilder.this.key);
                    element.setAttribute("value", token);
                    context.getNode().appendChild(element);
                }
                return null;
            }
        })).list(XmlUtils.findNode(this.xpathHref, new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                String token = (String)context.getSession().get(TransactionBuilder.this.key);
                if (token != null) {
                    Element element = (Element)context.getNode();
                    String href = element.getAttribute("href");
                    String newHref = String.valueOf(href) + (href.indexOf(63) >= 0 ? (char)'&' : '?') + TransactionBuilder.this.key + '=' + token;
                    element.setAttribute("href", newHref);
                }
                return null;
            }
        })));
    }

    public Collection<String> getIdCollection() {
        return Collections.unmodifiableCollection(this.idCollection);
    }

    public String getKey() {
        return this.key;
    }
}

