/*
 * Decompiled with CFR 0.152.
 */
package woolpack.convert;

import java.text.Format;
import java.util.Collection;
import java.util.regex.Pattern;
import woolpack.convert.CloneFormatFactory;
import woolpack.convert.FormatConverter;
import woolpack.convert.KeySetGetter;
import woolpack.convert.NetMaskConverter;
import woolpack.convert.ParseConverter;
import woolpack.convert.RegExpConverter;
import woolpack.convert.RetainKeys;
import woolpack.convert.ToBigDecimalConverter;
import woolpack.convert.ToBigIntegerConverter;
import woolpack.convert.ToByteConverter;
import woolpack.convert.ToDoubleConverter;
import woolpack.convert.ToFloatConverter;
import woolpack.convert.ToIntegerConverter;
import woolpack.convert.ToLongConverter;
import woolpack.convert.ToShortConverter;
import woolpack.convert.ToSqlDateConverter;
import woolpack.convert.ToStringConverter;
import woolpack.convert.ToTimestampConverter;
import woolpack.convert.TrysFn;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertUtils {
    public static final ToBigDecimalConverter TO_BIG_DECIMAL = new ToBigDecimalConverter();
    public static final ToBigIntegerConverter TO_BIG_INTEGER = new ToBigIntegerConverter();
    public static final ToByteConverter TO_BYTE = new ToByteConverter();
    public static final ToDoubleConverter TO_DOUBLE = new ToDoubleConverter();
    public static final ToFloatConverter TO_FLOAT = new ToFloatConverter();
    public static final ToIntegerConverter TO_INTEGER = new ToIntegerConverter();
    public static final ToLongConverter TO_LONG = new ToLongConverter();
    public static final ToShortConverter TO_SHORT = new ToShortConverter();
    public static final ToSqlDateConverter TO_SQL_DATE = new ToSqlDateConverter();
    public static final ToTimestampConverter TO_TIMESTAMP = new ToTimestampConverter();
    public static final ToStringConverter TO_STRING = new ToStringConverter();

    private ConvertUtils() {
    }

    public static <K> KeySetGetter<K> keySet() {
        return new KeySetGetter();
    }

    public static CloneFormatFactory formatFactory(Format format) {
        return new CloneFormatFactory(format);
    }

    public static FormatConverter format(Fn<?, Format> formatFactory) {
        return new FormatConverter(formatFactory);
    }

    public static NetMaskConverter netMask(String netMask) {
        return new NetMaskConverter(netMask);
    }

    public static ParseConverter parse(Fn<?, Format> formatFactory) {
        return new ParseConverter(formatFactory);
    }

    public static RegExpConverter convertRegExp(Pattern pattern, String replacement) {
        return new RegExpConverter(pattern, replacement);
    }

    public static <C, R> TrysFn<C, R> trys(Iterable<? extends Fn<? super C, ? extends R>> iterable) {
        return new TrysFn(iterable);
    }

    public static RetainKeys retainKeys(Collection<?> collection) {
        return new RetainKeys(collection);
    }
}

