/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.w3c.dom.Node;

import woolpack.convert.ConvertUtils;
import woolpack.factory.FactoryUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.samples.aa.AAServletTest;
import woolpack.samples.crud.SampleServletTest;
import woolpack.samples.frame.FrameServletTest;
import woolpack.samples.hello.HelloServletTest;
import woolpack.samples.locale.LocaleServletTest;
import woolpack.samples.transaction.TransactionServletTest;
import woolpack.utils.Utils;
import woolpack.xml.XmlUtils;

public class SamplesAllTests extends TestCase {

	public static final Map<String, String> ATTR_NAME_MAP = Utils.map("name", "value").map("id", null);

	public static Fn<String, Node> getFileToNode(final String regexp, final String replacement) {
		return FnUtils.join(
				ConvertUtils.convertRegExp(Pattern.compile(regexp), replacement),
				XmlUtils.nodeFactory(
						FactoryUtils.inputStreamReaderFactory(new Fn<String, InputStream>() {
							public InputStream exec(final String c) {
								try {
									return new FileInputStream(c);
								} catch (final FileNotFoundException e) {
									throw new IllegalStateException(e);
								}
							}
						}, "UTF-8"),
						XmlUtils.TRANSFORMER));
	}

	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(AAServletTest.class));
		suite.addTest(new TestSuite(SampleServletTest.class));
		suite.addTest(new TestSuite(FrameServletTest.class));
		suite.addTest(new TestSuite(HelloServletTest.class));
		suite.addTest(new TestSuite(LocaleServletTest.class));
		suite.addTest(new TestSuite(TransactionServletTest.class));
		return suite;
	}
}
