/*
 * Decompiled with CFR 0.152.
 */
package woolpack.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.ee.EEContext;
import woolpack.fn.Fn;
import woolpack.test.TestUtils;
import woolpack.utils.Utils;
import woolpack.xml.NodeFindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDomContextBuilder {
    public static final Iterable<String> ATTR_NAMES = Collections.singleton("id");
    private final Iterable<String> attrNames;
    private final Map<String, List<String>> input;
    private final EEContext context;
    private final Fn<String, NodeFindable> factory;

    public TestDomContextBuilder(Iterable<String> attrNames, Fn<String, NodeFindable> factory) {
        this.attrNames = attrNames;
        this.factory = factory;
        this.input = new HashMap<String, List<String>>();
        this.context = new EEContext();
        this.context.setConfig(new HashMap<String, Object>());
        this.context.setInput(this.input);
        this.context.setRequest(new HashMap<String, Object>());
        this.context.setSession(Utils.concurrentMap(new HashMap(), new Object()));
        this.context.setApplication(Utils.concurrentMap(new HashMap(), new Object()));
    }

    public TestDomContextBuilder(Fn<String, NodeFindable> factory) {
        this(ATTR_NAMES, factory);
    }

    public void init() {
        this.context.getInput().clear();
        this.context.getRequest().clear();
        this.context.setNode(null);
    }

    public void initXPath(String criteria) {
        this.context.getInput().clear();
        Node n = this.factory.exec(criteria).evaluateOne(this.context.getNode());
        if (n != null && n.getNodeType() == 1) {
            Element e = (Element)n;
            if (e.getNodeName().equals("FORM")) {
                this.input.putAll(TestUtils.selectForm(e));
                this.context.setId(e.getAttribute("action"));
            } else if (e.getNodeName().equals("A")) {
                String href = e.getAttribute("href");
                this.input.putAll(TestUtils.selectQuery(href));
                this.context.setId(href.substring(0, href.indexOf(63) >= 0 ? href.indexOf(63) : href.length()));
            }
        }
        this.context.getRequest().clear();
        this.context.setNode(null);
    }

    public Map<String, List<String>> getInput() {
        return this.input;
    }

    public EEContext get() {
        return this.context;
    }

    public boolean exists(String criteria) {
        return this.selectNode(criteria) != null;
    }

    public Node selectNode(String criteria) {
        return this.factory.exec(criteria).evaluateOne(this.context.getNode());
    }

    public Map<String, List<String>> selectEmbedded() {
        return TestUtils.selectEmbedded(this.attrNames, this.context.getNode());
    }
}

