/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import woolpack.config.ConfigContext;
import woolpack.id.IdContext;
import woolpack.utils.AppendableWriter;
import woolpack.utils.MapIterableMap;
import woolpack.utils.Utils;
import woolpack.web.WebContext;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlTransformerContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEContext
implements IdContext,
ConfigContext,
WebContext,
NodeContext {
    private String id;
    private Map<String, Object> config;
    private Object container;
    private Map input;
    private Map<String, Object> request;
    private ConcurrentMap<String, Object> session;
    private ConcurrentMap<String, Object> application;
    private Map<String, Object> beforeLocal;
    private Map<String, Object> local;
    private Node node;

    public EEContext() {
    }

    public EEContext(EEContext base) {
        this.id = base.id;
        this.config = base.config;
        this.container = base.container;
        this.input = base.input;
        this.request = base.request;
        this.session = base.session;
        this.application = base.application;
        this.beforeLocal = base.local != null ? base.local : base.beforeLocal;
        this.node = base.node;
    }

    public EEContext copy() {
        return new EEContext(this);
    }

    public Map<String, Object> getLocal() {
        if (this.local == null) {
            this.local = this.beforeLocal == null ? new HashMap<String, Object>() : new MapIterableMap<String, Object>((Iterable)Utils.list(new HashMap()).list(this.beforeLocal));
        }
        return this.local;
    }

    public void appendTo(Appendable sb) throws IOException {
        sb.append("DomContext dump information:");
        EEContext.appendTo(sb, "id", this.id);
        EEContext.appendTo(sb, "config", this.config);
        EEContext.appendTo(sb, "container", this.container);
        EEContext.appendTo(sb, "input", this.input);
        EEContext.appendTo(sb, "request", this.request);
        EEContext.appendTo(sb, "session", this.session);
        EEContext.appendTo(sb, "application", this.application);
        EEContext.appendTo(sb, "local", this.local);
        sb.append("\n,node:");
        if (this.node != null) {
            XmlTransformerContext context = new XmlTransformerContext();
            context.setSource(new DOMSource(this.node));
            context.setResult(new StreamResult(new AppendableWriter(sb)));
            XmlUtils.TRANSFORMER.exec(context);
        }
    }

    private static void appendTo(Appendable sb, String label, Object o) throws IOException {
        sb.append('\n');
        sb.append(',');
        sb.append(label);
        sb.append(':');
        if (o != null) {
            sb.append(o.toString());
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void setNode(Node node) {
        this.node = node;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public Object getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Object container) {
        this.container = container;
    }

    @Override
    public Map<String, Object> getRequest() {
        return this.request;
    }

    public void setRequest(Map<String, Object> request) {
        this.request = request;
    }

    @Override
    public ConcurrentMap<String, Object> getSession() {
        return this.session;
    }

    public void setSession(ConcurrentMap<String, Object> session) {
        this.session = session;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Map getInput() {
        return this.input;
    }

    public void setInput(Map input) {
        this.input = input;
    }

    @Override
    public ConcurrentMap<String, Object> getApplication() {
        return this.application;
    }

    public void setApplication(ConcurrentMap<String, Object> application) {
        this.application = application;
    }
}

