/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.web;

import junit.framework.TestCase;
import woolpack.container.ContainerContext;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.web.ContainerContextSetter;
import woolpack.web.WebContext;

public class ContainerContextSetterTest extends TestCase {
	public void testNormal() {
		final Fn<ContainerContext<WebContext>, Object> def = FnUtils.doNull();
		final Fn<WebContext, Void> fn = new ContainerContextSetter(def);
		final SimpleWebContext context = new SimpleWebContext();
		fn.exec(context);
		final ContainerContext containerContext = (ContainerContext) context.getContainer();
		assertEquals(def, containerContext.getFn());
		assertEquals(context, containerContext.getSubContext());
	}
}
