/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Node;

import woolpack.fn.Fn;

/**
 * 委譲先で生成したノードを設定する{@link Fn}です。
 * @author nakamura
 *
 */
public class NodeSetter<C extends NodeContext> implements Fn<C, Void> {
	private Fn<? super C, ? extends Node> fn;
	
	public NodeSetter(final Fn<? super C, ? extends Node> fn) {
		this.fn = fn;
	}

	public Void exec(final C c) {
		c.setNode(fn.exec(c));
		return null;
	}

	public Fn<? super C, ? extends Node> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, ? extends Node> fn) {
		this.fn = fn;
	}
}
