/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

import java.util.Map;
import java.util.Map.Entry;

import woolpack.fn.Fn;

/**
 * エレメント役を{@link Map}にキャストして、順次取り出した
 * キーと値を引数にして{@link Visitor#visit(Object)}に委譲する{@link Fn}です。
 * @author nakamura
 *
 */
public class MapAcceptor implements Fn<Visitor<?>, Void> {
	public Void exec(final Visitor<?> visitor) {
		final Map map = (Map) visitor.getElement();
		for (final Object entryObject : map.entrySet()) {
			final Entry entry = (Entry) entryObject;
			visitor.visit(entry.getKey());
			visitor.visit(entry.getValue());
		}
		return null;
	}
}
