/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Collection;
import java.util.Map;

import woolpack.bool.And;
import woolpack.bool.BooleanOperator;
import woolpack.fn.Fn;

/**
 * プロパティ名で委譲先を分岐する{@link Fn}です。
 * プロパティ名に対応する値が存在しない場合は委譲しないため、
 * ブラウザから送信されない項目を無視する際に使用します。
 * 
 * @author nakamura
 * 
 */
public class NameBranchIfExists extends NameBranch {

	/**
	 * @param operator 値検証一覧の呼び出し方。
	 * @param map プロパティ名と委譲先の対応表。
	 */
	public NameBranchIfExists(
			final BooleanOperator<ValidatorContext> operator,
			final Map<String, ? extends Fn<ValidatorContext, Boolean>> map) {
		super(operator, map);
	}

	/**
	 * {@link And}を使用します。
	 * @param map プロパティ名と委譲先の対応表。
	 */
	public NameBranchIfExists(
			final Map<String, ? extends Fn<ValidatorContext, Boolean>> map) {
		this(new And<ValidatorContext>(), map);
	}

	@Override
	protected Collection<String> keySet(final ValidatorContext context) {
		return context.getInputMap().keySet();
	}
}
