/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import woolpack.fn.Fn;
import woolpack.xml.NodeContext;

/**
 * テーブルの全ての列の上下同一値のセルを結合する{@link Fn}です。
 * @author nakamura
 *
 */
public class MergeCellAll implements Fn<NodeContext, Void> {

	public Void exec(final NodeContext c) {
		final Node trNode = HtmlUtils.TR.evaluateOne(c.getNode());
		if (trNode != null) {
			final NodeList tdList = HtmlUtils.TD.evaluateList(trNode);
			final MergeCell margeCell = new MergeCell(0);
			for (int i = tdList.getLength() - 1; i >= 0; i--) {
				margeCell.setColIndex(i);
				margeCell.exec(c);
			}
		}
		return null;
	}
}
