/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import woolpack.fn.Fn;

/**
 * 成功するまで順に委譲する{@link Fn}です。
 * @author nakamura
 *
 * @param <C>
 * @param <R>
 */
public class TrysFn<C, R> implements Fn<C, R> {
	private Iterable<? extends Fn<? super C, ? extends R>> iterable;
	
	public TrysFn(final Iterable<? extends Fn<? super C, ? extends R>> iterable) {
		this.iterable = iterable;
	}

	public R exec(final C c) {
		RuntimeException t = null;
		for (final Fn<? super C, ? extends R> fn : iterable) {
			try {
				return fn.exec(c);
			} catch (final RuntimeException e) {
				t = e;
			}
		}
		throw t;
	}

	public Iterable<? extends Fn<? super C, ? extends R>> getIterable() {
		return iterable;
	}
	public void setIterable(final Iterable<? extends Fn<? super C, ? extends R>> iterable) {
		this.iterable = iterable;
	}
}
