/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import woolpack.fn.Fn;

/**
 * {@link Object#equals(Object)}で同値関係をチェックする{@link Fn}です。
 * @author nakamura
 *
 */
public class EqualsChecker implements Fn<Object, Boolean> {
	private Object value;
	
	public EqualsChecker(final Object value) {
		this.value = value;
	}

	public Boolean exec(final Object c) {
		return value == null ? c == null : value.equals(c);
	}

	public Object getValue() {
		return value;
	}
	public void setValue(final Object value) {
		this.value = value;
	}
}
