/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

import java.util.Collection;

import woolpack.fn.Fn;

/**
 * コンテキスト役がコレクションに含まれることをチェックする{@link Fn}です。
 * @author nakamura
 *
 */
public class ContainsChecker implements Fn<Object, Boolean> {
	private Collection<?> collection;
	
	public ContainsChecker(final Collection<?> collection) {
		this.collection = collection;
	}

	public Boolean exec(final Object c) {
		return collection.contains(c);
	}

	public Collection<?> getCollection() {
		return collection;
	}
	public void setCollection(final Collection<?> collection) {
		this.collection = collection;
	}
}
