/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.ee.EEContext;
import woolpack.ee.Frame2TableTdWidth;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.utils.BuildableArrayList;
import woolpack.utils.Utils;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFindable;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameToTable
implements Fn<EEContext, Void> {
    private static final Fn<NodeContext, Void> BODY = XmlUtils.insertElementToParent("BODY");
    private static final Fn<NodeContext, Void> TABLE = XmlUtils.insertElementToParent("TABLE", XmlUtils.updateAttrValue("width", FnUtils.fix("100%")));
    private static final Fn<NodeContext, Void> TR = XmlUtils.insertElementToParent("TR");
    private static final Fn<NodeContext, Void> TD = XmlUtils.insertElementToParent("TD", FnUtils.seq(Utils.list(XmlUtils.updateAttrValue("align", FnUtils.fix("left"))).list(XmlUtils.updateAttrValue("valign", FnUtils.fix("top")))));
    private final NodeFindable xpathBody;
    private final NodeFindable xpathHtmlBody;
    private final NodeFindable xpathFrame;
    private final NodeFindable xpathFramesetRows;
    private final NodeFindable xpathFramesetCols;
    private final NodeFindable xpathFrame2;
    private final String frameId;
    private final Fn<EEContext, Void> nodeMaker;
    private final Fn<EEContext, Void> framesetRow;
    private final Fn<EEContext, Void> root;

    public FrameToTable(String frameId, final String targetName, final Fn<EEContext, Void> nodeMaker, Fn<String, NodeFindable> factory) {
        this.nodeMaker = nodeMaker;
        this.frameId = frameId;
        this.xpathBody = factory.exec("//BODY");
        this.xpathHtmlBody = factory.exec("/HTML/BODY");
        this.xpathFrame = factory.exec("//FRAME");
        this.xpathFramesetRows = factory.exec("FRAMESET[@rows]");
        this.xpathFramesetCols = factory.exec("FRAMESET[@cols]");
        NodeFindable xpathHtml = factory.exec("/HTML");
        this.xpathFrame2 = factory.exec("FRAME");
        final Fn removeTargetAttr = XmlUtils.findNode(factory.exec("//*[@target=\"" + targetName + "\"]"), XmlUtils.removeAttr("target"));
        Fn<EEContext, Void> processFrame = new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                Element element = (Element)context.getNode();
                if (targetName.equals(element.getAttribute("name"))) {
                    return null;
                }
                String id = context.getId();
                Node node = context.getNode();
                try {
                    context.setId(element.getAttribute("src"));
                    nodeMaker.exec(context);
                    removeTargetAttr.exec(context);
                    Node target = FrameToTable.this.xpathBody.evaluateOne(context.getNode());
                    Node child = target.getFirstChild();
                    while (child != null) {
                        node.getParentNode().insertBefore(XmlUtils.getDocumentNode(node).importNode(child, true), node);
                        child = child.getNextSibling();
                    }
                }
                finally {
                    context.setId(id);
                    context.setNode(node);
                }
                XmlUtils.REMOVE_THIS.exec(context);
                return null;
            }
        };
        Fn<EEContext, Void> processRow = new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                FrameToTable.this.framesetRow.exec(context);
                return null;
            }
        };
        this.framesetRow = FnUtils.seq(Utils.list(XmlUtils.findNode(this.xpathFramesetRows, FnUtils.seq((Iterable)new BuildableArrayList<Fn<NodeContext, Void>>().list(TR).list(TD).list(TABLE).list((Fn<NodeContext, Void>)processRow).list(XmlUtils.RETAIN_CHILDREN)))).list(XmlUtils.findNode(this.xpathFramesetCols, FnUtils.seq((Iterable)new BuildableArrayList<Fn<NodeContext, Void>>().list(TR).list(TD).list(TABLE).list(TR).list(new Frame2TableFramesetCol(processRow, processFrame)).list(XmlUtils.RETAIN_CHILDREN)))).list(XmlUtils.findNode(this.xpathFrame2, FnUtils.seq((Iterable)new BuildableArrayList<Fn<NodeContext, Void>>().list(TR).list(TD).list((Fn<NodeContext, Void>)processFrame)))));
        this.root = XmlUtils.findNode(xpathHtml, FnUtils.seq(Utils.list(XmlUtils.findNode(this.xpathFramesetRows, FnUtils.seq((Iterable)new BuildableArrayList<Fn<NodeContext, Void>>().list(BODY).list(TABLE).list((Fn<NodeContext, Void>)processRow).list(XmlUtils.RETAIN_CHILDREN)))).list(XmlUtils.findNode(this.xpathFramesetCols, FnUtils.seq((Iterable)new BuildableArrayList<Fn<NodeContext, Void>>().list(BODY).list(TABLE).list(TR).list(new Frame2TableFramesetCol(processRow, processFrame)).list(XmlUtils.RETAIN_CHILDREN))))));
    }

    @Override
    public Void exec(EEContext context) {
        Node base;
        String id = context.getId();
        Node node = context.getNode();
        try {
            context.setId(this.frameId);
            this.nodeMaker.exec(context);
            this.root.exec(context);
            base = context.getNode();
        }
        finally {
            context.setId(id);
            context.setNode(node);
        }
        this.nodeMaker.exec(context);
        Node baseBody = XmlUtils.getDocumentNode(context.getNode()).importNode(this.xpathHtmlBody.evaluateOne(base), true);
        Node baseFrame = this.xpathFrame.evaluateOne(baseBody);
        Node targetBody = this.xpathHtmlBody.evaluateOne(context.getNode());
        Node child = targetBody.getFirstChild();
        while (child != null) {
            baseFrame.getParentNode().insertBefore(child, baseFrame);
            child = targetBody.getFirstChild();
        }
        Node baseTd = baseFrame.getParentNode();
        baseTd.removeChild(baseFrame);
        Node child2 = baseBody.getFirstChild();
        while (child2 != null) {
            targetBody.appendChild(child2);
            child2 = baseBody.getFirstChild();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Frame2TableFramesetCol
    implements Fn<EEContext, Void> {
        private final Fn<EEContext, Void> processRow;
        private final Fn<EEContext, Void> processFrame;

        Frame2TableFramesetCol(Fn<EEContext, Void> processRow, Fn<EEContext, Void> processFrame) {
            this.processRow = processRow;
            this.processFrame = processFrame;
        }

        @Override
        public Void exec(EEContext context) {
            Fn e0 = XmlUtils.insertElementToParent("TD", FnUtils.seq((Iterable)new BuildableArrayList<Fn>().list(XmlUtils.updateAttrValue("align", FnUtils.fix("left"))).list(XmlUtils.updateAttrValue("valign", FnUtils.fix("top"))).list(new Frame2TableTdWidth(((Element)context.getNode()).getAttribute("cols")))));
            Fn e1 = FnUtils.seq(Utils.list(XmlUtils.findNode(FrameToTable.this.xpathFramesetRows, FnUtils.seq((Iterable)new BuildableArrayList<Fn>().list(e0).list(TABLE).list(this.processRow).list(XmlUtils.RETAIN_CHILDREN)))).list(XmlUtils.findNode(FrameToTable.this.xpathFramesetCols, FnUtils.seq((Iterable)new BuildableArrayList<Fn>().list(e0).list(TABLE).list(TR).list(new Frame2TableFramesetCol(this.processRow, this.processFrame)).list(XmlUtils.RETAIN_CHILDREN)))).list(XmlUtils.findNode(FrameToTable.this.xpathFrame2, FnUtils.seq((Iterable)Utils.list(e0).list(this.processFrame)))));
            e1.exec(context);
            return null;
        }
    }
}

