/*
 * Decompiled with CFR 0.152.
 */
package woolpack.bool;

import java.util.Collection;
import java.util.regex.Pattern;
import woolpack.bool.And;
import woolpack.bool.AndAnd;
import woolpack.bool.BoolSeq;
import woolpack.bool.BooleanConverter;
import woolpack.bool.BooleanOperator;
import woolpack.bool.CompareFn;
import woolpack.bool.ContainsAllChecker;
import woolpack.bool.ContainsChecker;
import woolpack.bool.Eq;
import woolpack.bool.EqEq;
import woolpack.bool.EqualsChecker;
import woolpack.bool.MaxChecker;
import woolpack.bool.MaxLengthChecker;
import woolpack.bool.MinChecker;
import woolpack.bool.MinLengthChecker;
import woolpack.bool.NotDelegator;
import woolpack.bool.NotEmptyChecker;
import woolpack.bool.NotFn;
import woolpack.bool.ObjectMatcher;
import woolpack.bool.Or;
import woolpack.bool.OrOr;
import woolpack.bool.RegExpChecker;
import woolpack.fn.FixFn;
import woolpack.fn.Fn;
import woolpack.fn.IfFn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoolUtils {
    public static final Fn<Object, Boolean> NOT_THROWABLE = BoolUtils.not(BoolUtils.matchObject(Throwable.class));
    public static final NotFn NOT = new NotFn();
    public static final NotEmptyChecker NOT_EMPTY = new NotEmptyChecker();
    public static final BooleanConverter TO_BOOLEAN = new BooleanConverter();

    private BoolUtils() {
    }

    public static <C> And<C> and() {
        return new And();
    }

    public static <C> AndAnd<C> andand() {
        return new AndAnd();
    }

    public static <C> BoolSeq<C> boolSeq(BooleanOperator<C> operator, Iterable<? extends Fn<? super C, Boolean>> iterable) {
        return new BoolSeq<C>(operator, iterable);
    }

    public static <C> BoolSeq<C> boolSeq(Iterable<? extends Fn<? super C, Boolean>> iterable) {
        return new BoolSeq(iterable);
    }

    public static <C extends Comparable<C>> CompareFn<C> compare(C value) {
        return new CompareFn<C>(value);
    }

    public static ContainsAllChecker containsAll(Collection<?> value) {
        return new ContainsAllChecker(value);
    }

    public static ContainsChecker contains(Collection<?> value) {
        return new ContainsChecker(value);
    }

    public static <C> Eq<C> eq() {
        return new Eq();
    }

    public static <C> EqEq<C> eqeq() {
        return new EqEq();
    }

    public static EqualsChecker checkEquals(Object value) {
        return new EqualsChecker(value);
    }

    public static <C extends Comparable<C>> MaxChecker<C> checkMax(C value) {
        return new MaxChecker<C>(value);
    }

    public static MaxLengthChecker checkMaxLength(int value) {
        return new MaxLengthChecker(value);
    }

    public static <C extends Comparable<C>> MinChecker<C> checkMin(C value) {
        return new MinChecker<C>(value);
    }

    public static MinLengthChecker checkMinLength(int value) {
        return new MinLengthChecker(value);
    }

    public static <C> NotDelegator<C> not(Fn<? super C, Boolean> fn) {
        return new NotDelegator<C>(fn);
    }

    public static ObjectMatcher matchObject(Object value) {
        return new ObjectMatcher(value);
    }

    public static <C> Or<C> or() {
        return new Or();
    }

    public static <C> OrOr<C> oror() {
        return new OrOr();
    }

    public static RegExpChecker checkRegExp(Pattern pattern) {
        return new RegExpChecker(pattern);
    }

    public static <C> IfFn<C, Boolean> ifTrue(Fn<? super C, ?> ifFn, Fn<? super C, ? extends Boolean> trueFn) {
        return new IfFn<C, Boolean>(ifFn, trueFn, new FixFn(false));
    }

    public static <C> IfFn<C, Boolean> ifNot(Fn<? super C, ?> ifFn, Fn<? super C, ? extends Boolean> falseFn) {
        return new IfFn<C, Boolean>(ifFn, new FixFn(true), falseFn);
    }
}

