/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.aa;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class AAComponent implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String loginName;
	private String loginPassword;
	private boolean valid;
	private Collection<String> roleCollection;
	
	public AAComponent() {
		valid = false;
	}
	
	/**
	 * 認証を行う。実装は説明用。
	 */
	public void login() {
		if (loginPassword != null) {
			valid = loginName != null && loginName.equals(loginPassword);
			loginPassword = null;
			roleCollection = Collections.singletonList((loginName.length() % 2 == 0) ? "even" : "odd");
		}
	}
	
	public String getLoginName() {
		return loginName;
	}
	public void setLoginName(final String loginName) {
		this.loginName = loginName;
	}
	public void setLoginPassword(final String loginPassword) {
		this.loginPassword = loginPassword;
	}
	public boolean isValid() {
		return valid;
	}
	public Collection<String> getRoleCollection() {
		return roleCollection;
	}
}
