/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.utils.Switchable;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;
import woolpack.visitor.VisitorConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsVisitorConstants {
    private static final Pattern LOCAL_CLASS_NAME = Pattern.compile("([^\\.]+\\.)*([^\\.]*)");
    public static final Acceptable<Object> PARAMS = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            boolean firstFlag = true;
            List<PropertyDescriptor> methodList = VisitorConstants.getConstructorGetterList(v.getClass());
            for (PropertyDescriptor property : methodList) {
                Object value = VisitorConstants.get(v, property.getReadMethod());
                if (firstFlag) {
                    firstFlag = false;
                } else {
                    sb.append(',');
                }
                visitor.visit(value);
            }
        }
    };
    public static final Acceptable<Iterable> ITERABLE = new Acceptable<Iterable>(){

        @Override
        public void accept(Visitor visitor, Iterable v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append('[');
            boolean flag = true;
            for (Object o : v) {
                if (flag) {
                    flag = false;
                } else {
                    sb.append(',');
                }
                visitor.visit(o);
            }
            sb.append(']');
        }
    };
    public static final Acceptable<Object> OBJECT = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append(v);
        }
    };
    public static final Acceptable<Map> MAP = new Acceptable<Map>(){

        @Override
        public void accept(Visitor visitor, Map v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append('{');
            boolean flag = true;
            Iterator iterator = v.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryObject;
                Map.Entry entry = entryObject = iterator.next();
                if (flag) {
                    flag = false;
                } else {
                    sb.append(',');
                }
                visitor.visit(entry.getKey());
                sb.append(':');
                visitor.visit(entry.getValue());
            }
            sb.append('}');
        }
    };

    private JsVisitorConstants() {
    }

    public static <V> Acceptable<V> objectAcceptable(final Object object) {
        return new Acceptable<V>(){

            @Override
            public void accept(Visitor visitor, V v) {
                StringBuilder sb = (StringBuilder)visitor.getContext();
                sb.append(object);
            }
        };
    }

    public static <V> Acceptable<V> classNameAcceptable(final Acceptable<V> child) {
        return new Acceptable<V>(){

            @Override
            public void accept(Visitor visitor, V v) {
                StringBuilder sb = (StringBuilder)visitor.getContext();
                sb.append("new ");
                sb.append(JsVisitorConstants.getLocalClassName(v.getClass()));
                sb.append('(');
                child.accept(visitor, v);
                sb.append(')');
            }
        };
    }

    public static <K, V> Acceptable<Switchable<K, V>> switchableAcceptable(final Object defaultKey) {
        return new Acceptable<Switchable<K, V>>(){

            @Override
            public void accept(Visitor visitor, Switchable<K, V> v) {
                StringBuilder sb = (StringBuilder)visitor.getContext();
                sb.append('{');
                boolean flag = true;
                for (Object key : v.keys()) {
                    if (flag) {
                        flag = false;
                    } else {
                        sb.append(',');
                    }
                    visitor.visit(key);
                    sb.append(':');
                    visitor.visit(v.get(key));
                }
                if (defaultKey != null && v.getDefault() != null) {
                    if (flag) {
                        flag = false;
                    } else {
                        sb.append(',');
                    }
                    visitor.visit(defaultKey);
                    sb.append(':');
                    visitor.visit(v.getDefault());
                }
                sb.append('}');
            }
        };
    }

    public static String getLocalClassName(Class clazz) {
        Matcher m = LOCAL_CLASS_NAME.matcher(clazz.getName());
        m.matches();
        return m.group(2);
    }

    public static Acceptable<Object> escapeStringAcceptable(final Acceptable<Object> child) {
        return new Acceptable<Object>(){
            private final Pattern patternT = Pattern.compile("\\t");
            private final Pattern patternN = Pattern.compile("\\n");
            private final Pattern patternR = Pattern.compile("\\r");
            private final Pattern patternF = Pattern.compile("\\f");
            private final Pattern patternA = Pattern.compile("\\a");
            private final Pattern patternE = Pattern.compile("\\e");

            @Override
            public void accept(Visitor visitor, Object v) {
                String s = v.toString();
                s = this.patternT.matcher(s).replaceAll("\\t");
                s = this.patternN.matcher(s).replaceAll("\\n");
                s = this.patternR.matcher(s).replaceAll("\\r");
                s = this.patternF.matcher(s).replaceAll("\\f");
                s = this.patternA.matcher(s).replaceAll("\\a");
                s = this.patternE.matcher(s).replaceAll("\\e");
                child.accept(visitor, String.valueOf('\"') + s + '\"');
            }
        };
    }
}

