/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import woolpack.utils.UtilsConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;
import woolpack.validator.ValidatorIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorConstants {
    public static final ValidatorExpression TRUE = new ValidatorExpression(){

        public boolean interpret(ValidatorContext context) {
            return true;
        }
    };
    public static final ValidatorExpression FALSE = new ValidatorExpression(){

        public boolean interpret(ValidatorContext context) {
            return false;
        }
    };
    public static final ValidatorExpression REQUIRED = new ValidatorExpression(){

        public boolean interpret(ValidatorContext context) {
            Object value = context.getTmpValue();
            return value != null && (!(value instanceof String) || ((String)value).length() > 0);
        }
    };
    public static final ValidatorIterable OR = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean result = false;
            boolean empty = true;
            for (ValidatorExpression validatorExpression : iterable) {
                empty = false;
                result |= validatorExpression.interpret(context);
            }
            return result || empty;
        }
    };
    public static final ValidatorIterable OROR = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean empty = true;
            for (ValidatorExpression validatorExpression : iterable) {
                empty = false;
                if (!validatorExpression.interpret(context)) continue;
                return true;
            }
            return empty;
        }
    };
    public static final ValidatorIterable AND = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean flag = true;
            for (ValidatorExpression validatorExpression : iterable) {
                flag &= validatorExpression.interpret(context);
            }
            return flag;
        }
    };
    public static final ValidatorIterable ANDAND = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            for (ValidatorExpression validatorExpression : iterable) {
                boolean flag = validatorExpression.interpret(context);
                if (flag) continue;
                return false;
            }
            return true;
        }
    };
    public static final ValidatorIterable EQ = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean trueFlag = true;
            boolean falseFlag = true;
            for (ValidatorExpression validatorExpression : iterable) {
                boolean flag = validatorExpression.interpret(context);
                trueFlag &= flag;
                falseFlag &= !flag;
            }
            return trueFlag || falseFlag;
        }
    };
    public static final ValidatorIterable EQEQ = new ValidatorIterable(){

        @Override
        public boolean interpret(ValidatorContext context, Iterable<? extends ValidatorExpression> iterable) {
            boolean trueFlag = true;
            boolean falseFlag = true;
            for (ValidatorExpression validatorExpression : iterable) {
                boolean flag = validatorExpression.interpret(context);
                if ((trueFlag &= flag) || (falseFlag &= !flag)) continue;
                return false;
            }
            return true;
        }
    };

    private ValidatorConstants() {
    }

    public static Map<String, List<Object>> convert(Map map) {
        HashMap<String, List<Object>> map1 = new HashMap<String, List<Object>>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            Iterable c = UtilsConstants.toIterable(entry.getValue());
            ArrayList list = new ArrayList();
            for (Object o : c) {
                list.add(o);
            }
            map1.put((String)entry.getKey(), list);
        }
        return map1;
    }
}

