/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import woolpack.utils.CheckUtils;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;

public class IfValidator
implements ValidatorExpression {
    private final ValidatorExpression ifExpression;
    private final ValidatorExpression trueExpression;
    private final ValidatorExpression falseExpression;

    public IfValidator(ValidatorExpression ifExpression, ValidatorExpression trueExpression, ValidatorExpression falseExpression) {
        CheckUtils.checkNotNull(ifExpression);
        CheckUtils.checkNotNull(trueExpression);
        CheckUtils.checkNotNull(falseExpression);
        this.ifExpression = ifExpression;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public IfValidator(ValidatorExpression ifExpression, ValidatorExpression trueExpression) {
        this(ifExpression, trueExpression, ValidatorConstants.TRUE);
    }

    public boolean interpret(ValidatorContext context) {
        return this.ifExpression.interpret(context) ? this.trueExpression.interpret(context) : this.falseExpression.interpret(context);
    }

    public ValidatorExpression getFalseExpression() {
        return this.falseExpression;
    }

    public ValidatorExpression getIfExpression() {
        return this.ifExpression;
    }

    public ValidatorExpression getTrueExpression() {
        return this.trueExpression;
    }
}

