/*
 * Decompiled with CFR 0.152.
 */
package woolpack.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import woolpack.utils.CheckUtils;
import woolpack.utils.SwitchBuilder;
import woolpack.utils.Switchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchableFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private Switchable<String, String> switchable;

    private void writeObject(ObjectOutputStream out) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String s : this.switchable.keys()) {
            map.put(s, this.switchable.get(s));
        }
        out.writeObject(map);
        out.writeObject(this.switchable.getDefault());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map map = (Map)in.readObject();
        String defaultValue = (String)in.readObject();
        SwitchBuilder<String, String> b = new SwitchBuilder<String, String>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            b.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.switchable = b.get(defaultValue);
    }

    public SwitchableFormat(Switchable<String, String> switchable) {
        CheckUtils.checkNotNull(switchable);
        this.switchable = switchable;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int start = toAppendTo.length();
        String o = this.switchable.get((String)obj);
        toAppendTo.append(o);
        pos.setBeginIndex(start);
        pos.setEndIndex(toAppendTo.length());
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        for (String key : this.switchable.keys()) {
            if (!source.startsWith(key, pos.getIndex())) continue;
            pos.setIndex(pos.getIndex() + key.length());
            return this.switchable.get(key);
        }
        String o = this.switchable.getDefault();
        pos.setIndex(source.length());
        return o;
    }

    public Switchable<String, String> getSwitchable() {
        return this.switchable;
    }
}

