/*
 * Decompiled with CFR 0.152.
 */
package woolpack.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.XmlToNode;
import woolpack.utils.StringReaderFactory;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtils {
    private static final Pattern QUERY = Pattern.compile("[\\?&]?([^=\\?]+)=([^&]*)");
    private static final String FORM_HEAD = "<HTML><BODY><FORM>";
    private static final String FORM_TAIL = "</FORM></BODY></HTML>";
    private static final String BODY_HEAD = "<HTML><BODY>";
    private static final String BODY_TAIL = "</BODY></HTML>";

    private TestUtils() {
    }

    private static void addTo(Map<String, List<String>> result, String key, String value) {
        List<String> list = result.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            result.put(key, list);
        }
        list.add(value);
    }

    public static Map<String, List<String>> selectQuery(String query) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        Matcher m = QUERY.matcher(query);
        while (m.find()) {
            TestUtils.addTo(result, m.group(1), m.group(2));
        }
        return result;
    }

    private static String getText(Node node) {
        StringBuilder sb = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeType() == 3) {
                sb.append(nodeList.item(i).getNodeValue());
            }
            ++i;
        }
        return sb.toString();
    }

    private static void selectForm(Node node, Map<String, List<String>> result, String selectName) {
        String name;
        if (node.getNodeType() == 1) {
            String value;
            Element e = (Element)node;
            String elementName = e.getNodeName();
            if ("OPTION".equals(elementName)) {
                name = selectName;
                value = e.hasAttribute("selected") ? e.getAttribute("value") : null;
            } else if (e.hasAttribute("name")) {
                String inputType;
                name = e.getAttribute("name");
                value = "SELECT".equals(elementName) ? null : ("INPUT".equals(elementName) ? ("radio".equals(inputType = e.getAttribute("type")) || "checkbox".equals(inputType) ? (e.hasAttribute("checked") ? (e.hasAttribute("value") ? e.getAttribute("value") : "") : null) : (e.hasAttribute("value") ? e.getAttribute("value") : "")) : ("BUTTON".equals(elementName) ? (e.hasAttribute("value") ? e.getAttribute("value") : "") : TestUtils.getText(e)));
            } else {
                name = selectName;
                value = null;
            }
            if (value != null) {
                TestUtils.addTo(result, name, value);
            }
        } else {
            name = null;
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                TestUtils.selectForm(n, result, name);
            }
            ++i;
        }
    }

    public static Map<String, List<String>> selectForm(Node node) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        TestUtils.selectForm(node, result, null);
        return result;
    }

    public static Map<String, List<String>> selectEmbedded(Iterable<String> attrNames, Node node) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        TestUtils.selectEmbedded(attrNames, node, result);
        return result;
    }

    private static void selectEmbedded(Iterable<String> attrNames, Node node, Map<String, List<String>> result) {
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            for (String attrName : attrNames) {
                if (!e.hasAttribute(attrName)) continue;
                TestUtils.addTo(result, e.getAttribute(attrName), TestUtils.getText(e));
                break;
            }
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            TestUtils.selectEmbedded(attrNames, nodeList.item(i), result);
            ++i;
        }
    }

    public static void print(DomContext context) {
        UtilsConstants.TRANSFORMER_FACTORY.newInstance().transform(new DOMSource(context.getNode()), new StreamResult(new OutputStreamWriter(System.out)));
    }

    public static DomExpression getToNodeForm(String s) {
        return TestUtils.getToNode(FORM_HEAD + s + FORM_TAIL);
    }

    public static DomExpression getToNodeBody(String s) {
        return TestUtils.getToNode(BODY_HEAD + s + BODY_TAIL);
    }

    public static DomExpression getToNode(String s) {
        return new XmlToNode(new StringReaderFactory(s));
    }

    public static boolean equalsForm(DomContext context, String expected) {
        return TestUtils.equals(context, FORM_HEAD + expected + FORM_TAIL);
    }

    public static boolean equalsBody(DomContext context, String expected) {
        return TestUtils.equals(context, BODY_HEAD + expected + BODY_TAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(DomContext context, String expected) {
        DomContext c = new DomContext();
        TestUtils.getToNode(expected).interpret(c);
        context.getNode().normalize();
        c.getNode().normalize();
        boolean result = TestUtils.equals(c.getNode(), context.getNode());
        if (result) return result;
        Class<TestUtils> clazz = TestUtils.class;
        synchronized (TestUtils.class) {
            PrintStream stream = System.out;
            stream.print("-- report start -- expected --");
            TestUtils.print(c);
            stream.print("-- but --");
            TestUtils.print(context);
            stream.println("-- report end --");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    public static boolean equals(Node node0, Node node1) {
        if (node0 == null) {
            return node1 == null;
        }
        if (node1 == null) {
            return false;
        }
        if (node0.getNodeType() != node1.getNodeType()) {
            return false;
        }
        if (node0.getNodeType() == 3 || node0.getNodeType() == 8) {
            return node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 2) {
            return node0.getNodeName().equals(node1.getNodeName()) && node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 9) {
            return TestUtils.equals(((Document)node0).getDocumentElement(), ((Document)node1).getDocumentElement());
        }
        if (!node0.getNodeName().equals(node1.getNodeName())) {
            return false;
        }
        Element e0 = (Element)node0;
        Element e1 = (Element)node1;
        NamedNodeMap map0 = e0.getAttributes();
        NamedNodeMap map1 = e1.getAttributes();
        if (map0.getLength() != map1.getLength()) {
            return false;
        }
        int i = 0;
        while (i < map0.getLength()) {
            if (!TestUtils.equals(map0.item(i), map1.item(i))) {
                return false;
            }
            ++i;
        }
        Node child0 = node0.getFirstChild();
        Node child1 = node1.getFirstChild();
        while (child0 != null || child1 != null) {
            if (!TestUtils.equals(child0, child1)) {
                return false;
            }
            child0 = child0.getNextSibling();
            child1 = child1.getNextSibling();
        }
        return true;
    }

    public static String toString(Reader reader) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while ((i = reader.read()) >= 0) {
                sb.append((char)i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static boolean equals(Object a, Object b) {
        boolean result = TestUtils.equalsPrivate(a, b);
        if (!result) {
            PrintStream stream = System.out;
            stream.print("-- equals start -- expected --");
            stream.print(a);
            stream.print("-- but --");
            stream.print(b);
            stream.println("-- equals end --");
        }
        return result;
    }

    private static boolean equalsPrivate(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof LinkedHashMap && b instanceof LinkedHashMap) {
            LinkedHashMap aMap = (LinkedHashMap)a;
            LinkedHashMap bMap = (LinkedHashMap)b;
            if (!TestUtils.equalsMap(aMap, bMap)) {
                return false;
            }
            Iterator aIterator = aMap.keySet().iterator();
            Iterator bIterator = bMap.keySet().iterator();
            while (aIterator.hasNext()) {
                if (TestUtils.equalsPrivate(aIterator.next(), bIterator.next())) continue;
                return false;
            }
            return true;
        }
        if (a instanceof Map) {
            if (b instanceof Map) {
                Map aMap = (Map)a;
                Map bMap = (Map)b;
                return TestUtils.equalsMap(aMap, bMap);
            }
            return false;
        }
        if (b instanceof Map) {
            return false;
        }
        if ((a instanceof List || a.getClass().isArray()) && (b instanceof List || a.getClass().isArray())) {
            List aList = UtilsConstants.toList(a);
            List bList = UtilsConstants.toList(b);
            if (aList.size() != bList.size()) {
                return false;
            }
            int length = aList.size();
            int i = 0;
            while (i < length) {
                if (!TestUtils.equalsPrivate(aList.get(i), bList.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (a instanceof Collection && b instanceof Collection) {
            return TestUtils.equalsCollection((Collection)a, (Collection)b);
        }
        return a.equals(b);
    }

    private static boolean equalsMap(Map a, Map b) {
        if (!TestUtils.equalsCollection(a.keySet(), b.keySet())) {
            return false;
        }
        for (Map.Entry entryObject : a.entrySet()) {
            Map.Entry entry = entryObject;
            if (TestUtils.equalsPrivate(entry.getValue(), b.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsCollection(Collection a, Collection b) {
        return TestUtils.containsAll(a, b) && TestUtils.containsAll(b, a);
    }

    private static boolean containsAll(Collection a, Collection b) {
        return a.containsAll(b);
    }

    public static Object sandwitchSerial(Object from) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(from);
        }
        finally {
            oos.close();
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
        }
    }
}

