/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.lang.reflect.Array;
import java.util.Collection;
import woolpack.el.convert.Convertable;
import woolpack.utils.CheckUtils;
import woolpack.utils.UtilsConstants;

public class CollectionConverter
implements Convertable {
    private final Convertable convertable;

    public CollectionConverter(Convertable convertable) {
        CheckUtils.checkNotNull(convertable);
        this.convertable = convertable;
    }

    public Object convert(Object beforeValue, Class toType, String propertyName) {
        Collection collection = UtilsConstants.toCollection(beforeValue);
        if (toType.isArray()) {
            Class<?> componentType = toType.getComponentType();
            Object afterArray = Array.newInstance(componentType, collection.size());
            int i = 0;
            boolean primitiveFlag = componentType.isPrimitive();
            for (Object before : collection) {
                Object after = this.convertable.convert(before, componentType, propertyName);
                if (!primitiveFlag || after != null) {
                    Array.set(afterArray, i, after);
                }
                ++i;
            }
            return afterArray;
        }
        if (Collection.class.isAssignableFrom(toType)) {
            return collection;
        }
        Object value = collection.iterator().next();
        return this.convertable.convert(value, toType, propertyName);
    }

    public Convertable getConvertable() {
        return this.convertable;
    }
}

