/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import woolpack.utils.MapBuilder;

abstract class AbstractNumberConverter {
    private static final Map<Class, AbstractNumberConverter> MAP = MapBuilder.get(new HashMap()).put(Byte.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return old.byteValue();
        }
    }).put(Short.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return old.shortValue();
        }
    }).put(Integer.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return old.intValue();
        }
    }).put(Long.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return old.longValue();
        }
    }).put(Float.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return Float.valueOf(old.floatValue());
        }
    }).put(Double.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return old.doubleValue();
        }
    }).put(BigInteger.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return BigInteger.valueOf(old.longValue());
        }
    }).put(BigDecimal.class, new AbstractNumberConverter(){

        Number convertLocal(Number old) {
            return new BigDecimal(old.doubleValue());
        }
    }).get();

    AbstractNumberConverter() {
    }

    abstract Number convertLocal(Number var1);

    static Number convert(Number old, Class toType) {
        if (toType.equals(old.getClass())) {
            return old;
        }
        return MAP.get(toType).convertLocal(old);
    }
}

