/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import woolpack.el.AbstractEL;
import woolpack.el.AbstractGettingEL;
import woolpack.el.EL;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingEL;
import woolpack.el.PropertyELFactory;
import woolpack.el.convert.Convertable;
import woolpack.utils.CheckUtils;

public class ReflectionPropertyELFactory
implements PropertyELFactory {
    private final Convertable convertable;

    public ReflectionPropertyELFactory(Convertable convertable) {
        CheckUtils.checkNotNull(convertable);
        this.convertable = convertable;
    }

    private BeanInfo generateBeanInfo(Class clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    public GettingEL newGetter(Class clazz, final String propertyName) {
        BeanInfo beanInfo = this.generateBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            PropertyDescriptor p = propertyDescriptorArray[n];
            if (p.getName().equals(propertyName)) {
                final Method m = p.getReadMethod();
                if (m == null) break;
                return new AbstractGettingEL(){

                    public Object getValue(Object root, Class toType) {
                        try {
                            Object result = m.invoke(root, new Object[0]);
                            return ReflectionPropertyELFactory.this.convertable.convert(result, toType, propertyName);
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ELTargetRuntimeException(e);
                        }
                    }
                };
            }
            ++n;
        }
        throw new IllegalArgumentException("property not found:" + clazz + ':' + propertyName);
    }

    public EL newSetter(Class clazz, final String propertyName) {
        BeanInfo beanInfo = this.generateBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            PropertyDescriptor p = propertyDescriptorArray[n];
            if (p.getName().equals(propertyName)) {
                final Method m = p.getWriteMethod();
                if (m == null) break;
                return new AbstractEL(){

                    public void setValue(Object root, Object value) {
                        try {
                            Object newValue = ReflectionPropertyELFactory.this.convertable.convert(value, m.getParameterTypes()[0], propertyName);
                            m.invoke(root, newValue);
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ELTargetRuntimeException(e);
                        }
                    }

                    public Object getValue(Object root, Class clazz) {
                        return null;
                    }
                };
            }
            ++n;
        }
        throw new IllegalArgumentException("property not found:" + clazz + ':' + propertyName);
    }

    public Convertable getConvertable() {
        return this.convertable;
    }
}

