/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.utils.CheckUtils;
import woolpack.utils.UtilsConstants;

public class Loop
implements DomExpression {
    private final GettingEL collectionEL;
    private final EL valueEL;
    private final DomExpression expression;

    public Loop(GettingEL collectionEL, EL valueEL, DomExpression expression) {
        CheckUtils.checkNotNull(collectionEL);
        CheckUtils.checkNotNull(valueEL);
        CheckUtils.checkNotNull(expression);
        this.collectionEL = collectionEL;
        this.valueEL = valueEL;
        this.expression = expression;
    }

    public void interpret(DomContext context) {
        Object value1 = this.collectionEL.getValue(context);
        Iterable iterable = UtilsConstants.toIterable(value1);
        for (Object value : iterable) {
            Node templateNode = context.getNode();
            Node parentNode = templateNode.getParentNode();
            Node newNode = templateNode.cloneNode(true);
            DomContext newContext = context.copy();
            newContext.setNode(newNode);
            this.valueEL.setValue(newContext, value);
            this.expression.interpret(newContext);
            parentNode.insertBefore(newNode, templateNode);
        }
        DomConstants.removeThis(context.getNode());
    }
}

