/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.w3c.dom.Node;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinProcess
implements DomExpression {
    public static final String KEY = "woolpack.dom.JOIN_PROCESS";
    private final DomExpression expression;
    private final String key;

    public JoinProcess(String key, DomExpression expression) {
        CheckUtils.checkNotEmpty(key);
        CheckUtils.checkNotNull(expression);
        this.key = key;
        this.expression = expression;
    }

    public JoinProcess(DomExpression expression) {
        this(KEY, expression);
    }

    private Process createPerSession(ConcurrentMap<String, Object> session, String id) {
        ConcurrentMap map = null;
        while ((map = (ConcurrentMap)session.get(this.key)) == null) {
            session.putIfAbsent(this.key, new ConcurrentHashMap());
        }
        Process process;
        while ((process = (Process)map.get(id)) == null) {
            map.putIfAbsent(id, new Process());
        }
        return process;
    }

    @Override
    public void interpret(DomContext context) {
        Process process = this.createPerSession(context.getSession(), context.getId());
        if (process.isNew()) {
            this.expression.interpret(context);
            process.setNode(context.getNode());
        } else {
            context.setNode(process.getNode());
        }
    }

    static class Process {
        private int count;
        private Node node;

        Process() {
        }

        synchronized boolean isNew() {
            ++this.count;
            return this.count == 1;
        }

        synchronized void setNode(Node node) {
            --this.count;
            if (this.count >= 1) {
                this.node = node;
            }
            this.notifyAll();
        }

        synchronized Node getNode() {
            try {
                while (this.node == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e);
                    }
                }
                Node node = this.node;
                return node;
            }
            finally {
                --this.count;
                if (this.count == 0) {
                    this.node = null;
                }
            }
        }
    }
}

