/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Evaluable;
import woolpack.utils.CheckUtils;

public class If
implements DomExpression {
    private final Evaluable eval;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public If(Evaluable eval, DomExpression trueExpression, DomExpression falseExpression) {
        CheckUtils.checkNotNull(eval);
        CheckUtils.checkNotNull(trueExpression);
        CheckUtils.checkNotNull(falseExpression);
        this.eval = eval;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public If(Evaluable eval, DomExpression trueExpression) {
        this(eval, trueExpression, DomConstants.NULL);
    }

    public void interpret(DomContext context) {
        Object o = this.eval.eval(context);
        if (Boolean.TRUE.equals(o)) {
            this.trueExpression.interpret(context);
        } else if (Boolean.FALSE.equals(o)) {
            this.falseExpression.interpret(context);
        }
    }
}

