/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.concurrent.ConcurrentMap;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;
import woolpack.utils.concurrent.Acquirable;
import woolpack.utils.concurrent.AcquirableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoAcquireSession
implements DomExpression {
    public static final String KEY = "woolpack.dom.TRY_SEMAPHORE";
    private final String key;
    private final AcquirableFactory factory;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public DoAcquireSession(String key, AcquirableFactory factory, DomExpression trueExpression, DomExpression falseExpression) {
        CheckUtils.checkNotEmpty(key);
        CheckUtils.checkNotNull(factory);
        CheckUtils.checkNotNull(trueExpression);
        CheckUtils.checkNotNull(falseExpression);
        this.key = key;
        this.factory = factory;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public DoAcquireSession(AcquirableFactory factory, DomExpression trueExpression, DomExpression falseExpression) {
        this(KEY, factory, trueExpression, falseExpression);
    }

    private Acquirable createPerSession(ConcurrentMap<String, Object> session) {
        Acquirable acquirable;
        while ((acquirable = (Acquirable)session.get(this.key)) == null) {
            session.putIfAbsent(this.key, this.factory.newInstance());
        }
        return acquirable;
    }

    @Override
    public void interpret(DomContext context) {
        Acquirable acquirable = this.createPerSession(context.getSession());
        if (acquirable.acquire()) {
            try {
                this.trueExpression.interpret(context);
            }
            finally {
                acquirable.release();
            }
        } else {
            this.falseExpression.interpret(context);
        }
    }
}

