/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;
import woolpack.utils.Switchable;
import woolpack.utils.concurrent.Acquirable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoAcquire
implements DomExpression {
    private final Switchable<String, Acquirable> map;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public DoAcquire(Switchable<String, Acquirable> map, DomExpression trueExpression, DomExpression falseExpression) {
        CheckUtils.checkNotNull(map);
        CheckUtils.checkNotNull(trueExpression);
        CheckUtils.checkNotNull(falseExpression);
        this.map = map;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public void interpret(DomContext context) {
        Acquirable acquirable = this.map.get(context.getId());
        if (acquirable != null) {
            if (acquirable.acquire()) {
                try {
                    this.trueExpression.interpret(context);
                }
                finally {
                    acquirable.release();
                }
            } else {
                this.falseExpression.interpret(context);
            }
        } else {
            this.trueExpression.interpret(context);
        }
    }
}

