/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import woolpack.crud.Executable;
import woolpack.crud.Expression;
import woolpack.crud.ExpressionFactory;
import woolpack.crud.Fetchable;
import woolpack.crud.Updatable;
import woolpack.crud.UpdatableFactory;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatableFactoryImpl
implements UpdatableFactory {
    private final ExpressionFactory factory;
    private final Executable executable;

    public UpdatableFactoryImpl(ExpressionFactory factory, Executable executable) {
        CheckUtils.checkNotNull(executable);
        CheckUtils.checkNotNull(factory);
        this.executable = executable;
        this.factory = factory;
    }

    @Override
    public Updatable newInstance(String id, Map<String, List<Object>> map) {
        final Expression expression = this.factory.newInstance(id, map);
        return new Updatable(){

            @Override
            public int update(Map<String, List<Object>> map) {
                final UpdateCountHolder holder = new UpdateCountHolder();
                UpdatableFactoryImpl.this.executable.execute(expression, new Fetchable(){

                    public void fetch(Statement statement) {
                        try {
                            holder.count = statement.getUpdateCount();
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }, map);
                return holder.count;
            }
        };
    }

    static class UpdateCountHolder {
        private int count;

        UpdateCountHolder() {
        }
    }
}

