/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import woolpack.crud.Updatable;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixUpdater
implements Updatable {
    private final String expression;
    private final DataSource dataSource;

    public FixUpdater(String expression, DataSource dataSource) {
        CheckUtils.checkNotEmpty(expression);
        CheckUtils.checkNotNull(dataSource);
        this.expression = expression;
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int update(Map<String, List<Object>> map) {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                int n;
                Statement statement = connection.createStatement();
                try {
                    n = statement.executeUpdate(this.expression);
                }
                catch (Throwable throwable) {
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return n;
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

