/*
 * Decompiled with CFR 0.152.
 */
package woolpack.container;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.container.AbstractComponentDef;
import woolpack.utils.AbstractKeyIteratorMap;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeContainer
extends AbstractKeyIteratorMap<String, Object> {
    public static final String KEY_PREFIX = "woolpack.container.SCOPE_CONTAINER.";
    private final String keyPrefix;
    private final Map<String, Object> request;
    private final ConcurrentMap<String, Object> session;
    private final ConcurrentMap<String, Object> application;
    private final Map<String, AbstractComponentDef> componentDefs;

    public ScopeContainer(String keyPrefix, Map<String, Object> request, ConcurrentMap<String, Object> session, ConcurrentMap<String, Object> application, Map<String, AbstractComponentDef> componentDefs) {
        CheckUtils.checkNotEmpty(keyPrefix);
        CheckUtils.checkNotNull(componentDefs);
        CheckUtils.checkNotNull(request);
        CheckUtils.checkNotNull(session);
        CheckUtils.checkNotNull(application);
        this.keyPrefix = keyPrefix;
        this.request = request;
        this.session = session;
        this.application = application;
        this.componentDefs = componentDefs;
    }

    public ScopeContainer(Map<String, Object> request, ConcurrentMap<String, Object> session, ConcurrentMap<String, Object> application, Map<String, AbstractComponentDef> componentDefs) {
        this(KEY_PREFIX, request, session, application, componentDefs);
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return Collections.unmodifiableSet(this.componentDefs.keySet()).iterator();
    }

    @Override
    protected Object getValue(Object key) {
        String keyString = (String)key;
        AbstractComponentDef componentDef = this.componentDefs.get(keyString);
        Object result = componentDef.getComponent(String.valueOf(this.keyPrefix) + keyString, this);
        return result;
    }

    @Override
    public Object get(Object key) {
        return this.getValue(key);
    }

    ConcurrentMap<String, Object> getApplication() {
        return this.application;
    }

    Map<String, Object> getRequest() {
        return this.request;
    }

    ConcurrentMap<String, Object> getSession() {
        return this.session;
    }
}

