/*
 * Decompiled with CFR 0.152.
 */
package woolpack.config;

import java.util.Map;
import woolpack.config.ConfigContext;
import woolpack.config.ConfigExpression;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap
implements ConfigExpression {
    private static final Object DEFAULT_KEY = new Object();
    private final ConfigExpression mapMaker;
    private final Map<Object, Map<String, Object>> cacheMap;

    public CacheMap(Map<Object, Map<String, Object>> cacheMap, ConfigExpression mapMaker) {
        CheckUtils.checkNotNull(mapMaker);
        this.cacheMap = cacheMap;
        this.mapMaker = mapMaker;
    }

    @Override
    public void interpret(ConfigContext context) {
        if (this.cacheMap == null) {
            this.mapMaker.interpret(context);
        } else {
            Object key = this.getCacheKey();
            Map<String, Object> map = this.cacheMap.get(key);
            if (map == null) {
                this.mapMaker.interpret(context);
                map = context.getMap();
                this.cacheMap.put(key, map);
            }
            context.setMap(map);
        }
    }

    public Object getCacheKey() {
        return DEFAULT_KEY;
    }
}

