/*
 * Decompiled with CFR 0.152.
 */
package woolpack.action;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import woolpack.action.ActionDef;
import woolpack.action.ActionResult;
import woolpack.action.ForwardDef;
import woolpack.action.ForwardDefNotFoundRuntimeException;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.PropertyEL;
import woolpack.utils.CheckUtils;
import woolpack.utils.Switchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionInvoker {
    private final Switchable<String, ActionDef> switchable;
    private final Iterable<ForwardDef> iterable;

    public ActionInvoker(Switchable<String, ActionDef> switchable, Iterable<ForwardDef> iterable) {
        CheckUtils.checkNotNull(switchable);
        CheckUtils.checkNotNull(iterable);
        this.switchable = switchable;
        this.iterable = iterable;
    }

    public ActionInvoker(Switchable<String, ActionDef> switchable, ForwardDef ... array) {
        this(switchable, (Iterable<ForwardDef>)Arrays.asList(array));
    }

    public ActionResult invoke(Object root, String id, Map inputMap) {
        ActionDef actionDef = this.switchable.get(id);
        CheckUtils.checkNotNull(actionDef);
        ActionInvoker.setValuesTo(actionDef.getComponentEL().getValue(root), inputMap, this);
        try {
            try {
                Object result = actionDef.getMethodEL().getValue(root);
                return ActionInvoker.findId(actionDef.getForwardDefIterable(), result);
            }
            catch (ELTargetRuntimeException e) {
                return ActionInvoker.findId(actionDef.getForwardDefIterable(), e.getCause());
            }
        }
        catch (ForwardDefNotFoundRuntimeException e) {
            return ActionInvoker.findId(this.iterable, e.getReturnedObject());
        }
    }

    public static void setValuesTo(Object root, Map inputMap, ActionInvoker invoker) {
        if (root == null) {
            return;
        }
        Iterator iterator = inputMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            try {
                new PropertyEL((String)entry.getKey()).setValue(root, entry.getValue());
            }
            catch (RuntimeException exception) {
                if (invoker == null) continue;
                invoker.handleRuntimeException(exception);
            }
        }
    }

    protected void handleRuntimeException(RuntimeException exception) {
    }

    public static ActionResult findId(Iterable<ForwardDef> iterable, Object aReturnedObject) {
        for (ForwardDef forwardDef : iterable) {
            if (!forwardDef.getMatchable().matches(aReturnedObject)) continue;
            return new ActionResult(forwardDef, aReturnedObject);
        }
        throw new ForwardDefNotFoundRuntimeException(aReturnedObject);
    }
}

