/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Arrays;

import junit.framework.TestCase;

public class SerialValidatorTest extends TestCase {

	public void testConstructor() {
		try {
			new SerialValidator((ValidatorIterable) null,
					ValidatorConstants.FALSE);
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new SerialValidator(ValidatorConstants.AND,
					(Iterable<ValidatorExpression>) null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testAndFalseTrue() {
		final CountValidator counter0 = new CountValidator(
				ValidatorConstants.FALSE);
		final CountValidator counter1 = new CountValidator(
				ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(
				ValidatorConstants.AND, counter0, counter1);
		final ValidatorContext context = new ValidatorContext();
		assertFalse(expression.interpret(context));
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
		assertTrue(context == counter0.getContextList().getLast());
		assertTrue(context == counter1.getContextList().getLast());
	}

	public void testAndAndArray() {
		final CountValidator counter0 = new CountValidator(
				ValidatorConstants.TRUE);
		final CountValidator counter1 = new CountValidator(
				ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(counter0,
				counter1);
		final ValidatorContext context = new ValidatorContext();
		assertTrue(expression.interpret(context));
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
		assertTrue(context == counter0.getContextList().getLast());
		assertTrue(context == counter1.getContextList().getLast());
	}

	public void testAndAndList() {
		final CountValidator counter0 = new CountValidator(
				ValidatorConstants.TRUE);
		final CountValidator counter1 = new CountValidator(
				ValidatorConstants.TRUE);
		final ValidatorExpression expression = new SerialValidator(Arrays
				.asList(counter0, counter1));
		final ValidatorContext context = new ValidatorContext();
		assertTrue(expression.interpret(context));
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
		assertTrue(context == counter0.getContextList().getLast());
		assertTrue(context == counter1.getContextList().getLast());
	}
}
