/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import junit.framework.TestCase;

public class DumpValidatorTest extends TestCase {

	public void testConstructor() {
		try {
			new DumpValidator(null);
			fail();
		} catch (final NullPointerException e) {
		}
	}

	public void testNormal() {
		final CountValidator counter0 = new CountValidator(
				ValidatorConstants.TRUE);
		final ValidatorExpression expression = new DumpValidator(counter0);
		final ValidatorContext context = new ValidatorContext();
		context.setId("id0");
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
	}

	public void testException() {
		final CountValidator counter0 = new CountValidator(new MaxValidator(5));
		final ValidatorExpression expression = new DumpValidator(counter0);
		final ValidatorContext context = new ValidatorContext();
		context.setId("id0");
		try {
			expression.interpret(context);
			fail();
		} catch (final IllegalStateException expected) {
			assertTrue(expected.getCause() instanceof NullPointerException);
			assertEquals(
					"ValidatorContext dump information:\n,id:id0\n,inputMap:\n,collectable:\n,tmpKey:\n,tmpIndex:0",
					expected.getMessage());
		}
		assertEquals(1, counter0.getCount());
	}
}
