/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.LinkedList;

import junit.framework.TestCase;

public class CountValidatorTest extends TestCase {

	public void testConstructor() {
		try {
			new CountValidator(null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testGetCountTrue() {
		final CountValidator counter1 = new CountValidator(
				ValidatorConstants.TRUE);
		final CountValidator counter0 = new CountValidator(counter1);
		final LinkedList<ValidatorContext> expectedList = new LinkedList<ValidatorContext>();
		assertEquals(0, counter1.getCount());
		assertEquals(0, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());

		expectedList.add(new ValidatorContext());
		assertTrue(counter0.interpret(expectedList.getLast()));
		assertEquals(1, counter1.getCount());
		assertEquals(1, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());

		expectedList.add(new ValidatorContext());
		assertTrue(counter0.interpret(expectedList.getLast()));
		assertEquals(2, counter1.getCount());
		assertEquals(2, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());
	}

	public void testGetCountFalse() {
		final CountValidator counter1 = new CountValidator(
				ValidatorConstants.FALSE);
		final CountValidator counter0 = new CountValidator(counter1);
		final LinkedList<ValidatorContext> expectedList = new LinkedList<ValidatorContext>();
		assertEquals(0, counter1.getCount());
		assertEquals(0, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());

		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		assertEquals(1, counter1.getCount());
		assertEquals(1, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());

		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		assertEquals(2, counter1.getCount());
		assertEquals(2, counter0.getCount());
		assertEquals(expectedList, counter1.getContextList());
		assertEquals(expectedList, counter0.getContextList());
	}

	public void testGetZero() {
		final CountValidator counter1 = new CountValidator(0,
				ValidatorConstants.FALSE);
		final LinkedList<ValidatorContext> expectedList = new LinkedList<ValidatorContext>();
		assertEquals(0, counter1.getContextList().size());

		expectedList.add(new ValidatorContext());
		assertFalse(counter1.interpret(expectedList.getLast()));
		assertEquals(0, counter1.getContextList().size());

		expectedList.add(new ValidatorContext());
		assertFalse(counter1.interpret(expectedList.getLast()));
		assertEquals(0, counter1.getContextList().size());
	}

	public void testGetMax() {
		final CountValidator counter0 = new CountValidator(4,
				ValidatorConstants.FALSE);
		final LinkedList<ValidatorContext> expectedList = new LinkedList<ValidatorContext>();

		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		assertEquals(expectedList, counter0.getContextList());

		expectedList.add(new ValidatorContext());
		assertFalse(counter0.interpret(expectedList.getLast()));
		expectedList.removeFirst();
		assertEquals(expectedList, counter0.getContextList());
	}
}
