/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;
import java.io.Writer;

import junit.framework.TestCase;

public class AppendableWriterTest extends TestCase {

	public void testConstructor() throws IOException {
		try {
			final Writer w = new AppendableWriter(null);
			fail();
			try {
			} finally {
				w.close();
			}
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() throws IOException {
		final StringBuilder sb = new StringBuilder();
		final Writer w = new AppendableWriter(sb);
		w.append("ab");
		w.append("abcdef", 2, 4);
		w.append('e');
		w.write("efgh".toCharArray(), 1, 2);
		w.write('h');
		w.write("ij");
		w.write("jklm", 1, 2);
		assertEquals("abcdefghijkl", sb.toString());
		w.flush();
		assertEquals("abcdefghijkl", sb.toString());
		w.close();
		assertEquals("abcdefghijkl", sb.toString());
	}
}
