/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.io.IOException;
import java.text.Format;
import java.text.ParseException;

import junit.framework.TestCase;
import woolpack.test.TestUtils;
import woolpack.utils.SwitchBuilder;
import woolpack.utils.Switchable;

public class SwitchableFormatTest extends TestCase {

	public void testConstructor() {
		try {
			new SwitchableFormat((Switchable<String, String>) null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	private void scenario(final Format format) throws ParseException {
		assertEquals("value0", format.format("key0"));
		assertEquals("value1", format.format("key1"));
		assertEquals("value2", format.format("key2"));
		assertEquals("defaultValue", format.format("key3"));
		assertEquals("value0", format.parseObject("key0"));
		assertEquals("value1", format.parseObject("key1"));
		assertEquals("value2", format.parseObject("key2"));
		assertEquals("defaultValue", format.parseObject("key3"));
	}

	private void scenarioDefaultNull(final Format format) throws ParseException {
		assertEquals("value0", format.format("key0"));
		assertEquals("value1", format.format("key1"));
		assertEquals("value2", format.format("key2"));
		assertEquals("null", format.format("key3"));
		assertEquals("value0", format.parseObject("key0"));
		assertEquals("value1", format.parseObject("key1"));
		assertEquals("value2", format.parseObject("key2"));
		assertEquals(null, format.parseObject("key3"));
	}

	public void testNormal() throws ParseException, IOException, ClassNotFoundException {
		{
			final Format format0 = new SwitchableFormat(
					new SwitchBuilder<String, String>().put("key0", "value0")
							.put("key1", "value1").put("key2", "value2").get(
									"defaultValue"));
			scenario(format0);
			final Format format1 = (Format) format0.clone();
			scenario(format1);
			scenario((Format) TestUtils.sandwitchSerial(format1));
		}
		{
			final Format format0 = new SwitchableFormat(
					new SwitchBuilder<String, String>().put("key0", "value0")
							.put("key1", "value1").put("key2", "value2").get());
			scenarioDefaultNull(format0);
			final Format format1 = (Format) format0.clone();
			scenarioDefaultNull(format1);
			scenarioDefaultNull((Format) TestUtils.sandwitchSerial(format1));
		}
	}
}
