/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class LocaleAllTests extends TestCase {

	public static Test suite() {

		final TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(BranchByLocaleTest.class));
		suite.addTest(new TestSuite(BranchByLocaleValidatorTest.class));
		suite.addTest(new TestSuite(LocaleCacheMapTest.class));
		suite.addTest(new TestSuite(LocaleCacheNodeTest.class));
		suite.addTest(new TestSuite(LocaleConstantsTest.class));
		suite.addTest(new TestSuite(LocaleFormatFactoryTest.class));
		suite.addTest(new TestSuite(LocaleIdTest.class));
		suite.addTest(new TestSuite(LocalePutResourceBundleTest.class));
		suite.addTest(new TestSuite(LocaleReaderFactoryTest.class));
		return suite;
	}
}
