/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import junit.framework.TestCase;
import woolpack.adapter.JXPFactory;
import woolpack.dom.Branch;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.test.TestUtils;
import woolpack.utils.SwitchBuilder;

public class FrameToTableTest extends TestCase {

	public void testConstructor() {
		try {
			new FrameToTable(null, "target", DomConstants.NULL,
					new JXPFactory());
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new FrameToTable("", "target", DomConstants.NULL, new JXPFactory());
			fail();
		} catch (final StringIndexOutOfBoundsException expected) {
		}
		try {
			new FrameToTable("frame", null, DomConstants.NULL, new JXPFactory());
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new FrameToTable("frame", "", DomConstants.NULL, new JXPFactory());
			fail();
		} catch (final StringIndexOutOfBoundsException expected) {
		}
		try {
			new FrameToTable("frame", "target", null, new JXPFactory());
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new FrameToTable("frame", "target", DomConstants.NULL, null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final DomExpression e = new FrameToTable(
				"frame",
				"target",
				new Branch<String>(
						DomConstants.EVAL_ID,
						new SwitchBuilder<String, DomExpression>()
								.put(
										"frame",
										TestUtils
												.getToNode("<HTML>"
														+ "<FRAMESET rows=\"10%,*,10%\">"
														+ "<FRAME src=\"headSrc\" name=\"head\" />"
														+ "<FRAMESET cols=\"20%,*\">"
														+ "<FRAME src=\"menuSrc\" name=\"menu\" />"
														+ "<FRAME src=\"blankSrc\" name=\"target\" />"
														+ "</FRAMESET>"
														+ "<FRAME src=\"footSrc\" name=\"foot\" />"
														+ "</FRAMESET>"
														+ "</HTML>")).put(
										"headSrc",
										TestUtils.getToNodeBody("bodyhead0"))
								.put("footSrc",
										TestUtils.getToNodeBody("bodyfoot0"))
								.put("menuSrc",
										TestUtils.getToNodeBody("bodymenu0"))
								.put("target0",
										TestUtils.getToNodeBody("bodytarget0"))
								.get()), new JXPFactory());

		final DomContext context = new DomContext();
		context.setId("target0");
		e.interpret(context);

		assertTrue(TestUtils
				.equalsBody(
						context,
						"<TABLE width=\"100%\">"
								+ "<TR><TD align=\"left\" valign=\"top\">bodyhead0</TD></TR>"
								+ "<TR><TD align=\"left\" valign=\"top\">"
								+ "<TABLE width=\"100%\"><TR>"
								+ "<TD width=\"20%\" align=\"left\" valign=\"top\">bodymenu0</TD>"
								+ "<TD width=\"80%\" align=\"left\" valign=\"top\">bodytarget0</TD>"
								+ "</TR></TABLE>"
								+ "</TD></TR>"
								+ "<TR><TD align=\"left\" valign=\"top\">bodyfoot0</TD></TR>"
								+ "</TABLE>"));
	}

	// public void testNormalNotDocumentNode() {
	// final Map<String, DomExpression> map = new HashMap<String,
	// DomExpression>();
	// map.put("frame", TestUtils.getToNode(
	// "<HTML>" +
	// "<FRAMESET rows=\"10%,*, 10%\">" +
	// "<FRAME src=\"headSrc\" name=\"head\" />" +
	// "<FRAMESET cols=\"20%,*\">" +
	// "<FRAME src=\"menuSrc\" name=\"menu\" />" +
	// "<FRAME src=\"blankSrc\" name=\"target\" />" +
	// "</FRAMESET>" +
	// "<FRAME src=\"footSrc\" name=\"foot\" />" +
	// "</FRAMESET>" +
	// "</HTML>"));
	// map.put("headSrc", TestUtils.getToNode("bodyhead0") {
	// @Override public void interpret(final DomContext context) {
	// super.interpret(context);
	// context.setNode(((Document)context.getNode()).getDocumentElement());
	// }
	// });
	// map.put("footSrc", TestUtils.getToNode("bodyfoot0") {
	// @Override public void interpret(final DomContext context) {
	// super.interpret(context);
	// context.setNode(((Document)context.getNode()).getDocumentElement());
	// }
	// });
	// map.put("menuSrc", TestUtils.getToNode("bodymenu0") {
	// @Override public void interpret(final DomContext context) {
	// super.interpret(context);
	// context.setNode(((Document)context.getNode()).getDocumentElement());
	// }
	// });
	// map.put("target0", "bodytarget0"+ TestUtils.BODY_TAIL) {
	// @Override public void interpret(final DomContext context) {
	// super.interpret(context);
	// context.setNode(((Document)context.getNode()).getDocumentElement());
	// }
	// });
	// final DomExpression e = new FrameToTable("frame", "target", new
	// BranchById(map, DomConstants.NULL));
	//
	// final DomContext context = new DomContext();
	// context.setId("target0");
	// e.interpret(context);
	//
	// final Node expected = TestUtils.createNodeFromHtml(
	// TestUtils.BODY_HEAD +
	// "<TABLE width=\"100%\">" +
	// "<TR><TD align=\"left\" valign=\"top\">bodyhead0</TD></TR>" +
	// "<TR><TD align=\"left\" valign=\"top\">" +
	// "<TABLE width=\"100%\"><TR>" +
	// "<TD width=\"20%\" align=\"left\" valign=\"top\">bodymenu0</TD>" +
	// "<TD width=\"80%\" align=\"left\" valign=\"top\">bodytarget0</TD>" +
	// "</TR></TABLE>" +
	// "</TD></TR>" +
	// "<TR><TD align=\"left\" valign=\"top\">bodyfoot0</TD></TR>" +
	// "</TABLE>"+
	// TestUtils.BODY_TAIL);
	// assertTrue(TestUtils.equals(((Document)expected).getDocumentElement(),
	// context.getNode()));
	// }
}
